/************************************************************************
 * ifchk.h                                                              *
 *                                                                      *
 * Copyright (C) 2002, 2003 Joshua Birnbaum <engineer@noorg.org>.       *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/*************************************************************
 * project ifchk -- host based network interface promiscuous *
 *                  mode detection and handling.             *
 *						             *
 * vers 0.94						     *
 *							     *
 * standard header file		                             *
 *************************************************************/

/**********************
 * include directives *
 **********************/

#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/route.h>
#include <sys/sysctl.h>
#include <sys/utsname.h>
#include <syslog.h>
#include <stdlib.h>


/*********************
 * define directives *
 *********************/

#define VERS "0.95b1"		/* ifchk revision number. */
#define FALSE 0			/* Value of false. */
#define TRUE 1			/* Value of true. */
#define DOWN 2			/* Interface down. */
#define NORMAL 3		/* Interface normal/up. */
#define PROMISC 4		/* Interface promiscuous. */
#define PROMISC_DISABLE 5	/* Interface promiscuous, disabled. */
#define LOGWARNING 6		/* Logging priority. */
#define LOGINFO 7		/* Logging priority. */
#define NULLSTATE 8		/* Dummy interface state - for ifMetric(). */
#define DATASZ 16		/* Size of ifList 'data' struct member. */
#define KBUFSZ 1024		/* Space for configured interface list. */


/***********************
 * global declarations *
 ***********************/

struct ifList
{
    char data[DATASZ];		/* struct ifList data space. */
    struct ifList *next;	/* Pointer to next struct ifList. */
};

int dFlag = FALSE;		/* Interface disable flag. */
int iFlag = FALSE;		/* Interface metrics flag. */
int nullFlag = FALSE;		/* Dummy interface flag - for ifStat(). */


/***********************
 * function prototypes *
 ***********************/

int ifStat();
int ifMetric( struct ifList *list ); 
int writeLog( int priority, char *object, int ifState );
void ifchkHelp();
void ifchkRev();

