/************************************************************************
 * linux.h                                                              *
 *                                                                      *
 * Copyright (C) 2002 - 2004 Joshua Birnbaum <engineer@noorg.org>.      *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/*************************************************************
 * Project ifchk -- Host based network interface promiscuous *
 *                  mode detection and handling.             *
 *                                                           *
 * Version:         0.95b2				     *
 *                                                           *
 * --------------------------------------------------------- *
 *                                                           *
 * linux.h:         Standard header file.                    *
 *************************************************************/

/**********************
 * include directives *
 **********************/

#ifndef LINUX_H 
#define LINUX_H 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/sysctl.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <linux/rtnetlink.h>

#include "common.h"
#include "log.h"


/*********************
 * define directives *
 *********************/

#define DATASZ 16			/* Size of ifList "data" struct member. */
#define IOVBUFSZ 8192			/* Size of buffer for interface data. */


/***********************
 * global declarations *
 ***********************/

/*
 * netlink socket structure definition.
 */
struct nlSockStruct
{
    int nlsockfd;			/* netlink socket descriptor. */ 
    struct sockaddr_nl client;		/* netlink socket address structure. */ 
    int sequence;			/* netlink message sequence number. */
} nlSock;

/*
 * netlink header structure definition.
 */
struct nlMsgStruct
{
    struct nlmsghdr hdr;		/* netlink mesage header. */ 
    struct rtgenmsg payload;		/* rtnetlink address family dependent message. */ 
};

/*
 * Interface structure definition.
 */
struct ifList
{
    int flags;				/* Interface flags. */
    char data[DATASZ];			/* Interface name/unit number, e.g., "eth0". */
    struct ifList *next;		/* Pointer to next struct ifList. */
};


/***********************
 * function prototypes *
 ***********************/

int nlCreateSock( struct nlSockStruct *nlSock );
int nlSndMsg( struct nlSockStruct *nlSock );
int nlRcvMsg( struct nlSockStruct *nlSock );
int processFlags( struct ifList *list, int count );
int ifMetric( struct ifList *list );

#endif /* LINUX_H */
