/************************************************************************
 * uid.c                                                                *
 *                                                                      *
 * Copyright (C) 2002 - 2004 Joshua Birnbaum <engineer@noorg.org>.      *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/***************************************************************
 * Project ifchk -- Host based network interface promiscuous   *
 *                  mode detection and handling.               *
 *                                                             *
 * Version:         0.95b2                                     *
 *                                                             *
 * ----------------------------------------------------------- *
 *                                                             *
 * uid.c:           ifchk credential check subsystem.          *
 *                                                             *
 * Module                                                      *
 * Functions:     - Discovers identity of user invoking ifchk. *
 ***************************************************************/

/**********************
 * include directives *
 **********************/

#include "uid.h"


/******************************************************
 * credentials()  - Returns credentials data on the   *
 *                  user invoking ifchk.              *
 *                                                    *
 * Parameters:      None.                             *
 *                                                    *
 * Returns:         struct of type passwd on success. *
 *                  NULL on failure.                  *
 ******************************************************/

struct passwd *credentials()
{
    struct passwd *pwData = NULL;

    /*
     * Do we have a UID 0 password database entry to authenticate 
     * with for privileged operations (ie. interface shutdown)?
     */
    if( ( pwData = getpwuid( 0 ) ) == NULL)
    {
        perror( "getpwuid" );
        return (NULL);
     }

    if( pwData -> pw_uid != 0 ) 
    {
        fprintf( stderr, "ifchk: ERROR: UID 0 does not exist in password database\n" );
        return (NULL);
     }

    /*
     * If we do, check that the UID 0 name field entry is "root".
     */
    if( ( strncmp( pwData -> pw_name, "root", sizeof( "root" ) ) ) != 0 )
    {
        printf( "ifchk: WARNING: UID 0 name field entry in password database is \"%s\"\n",
                                                                         pwData -> pw_name );
     }

    /*
     * With UID 0 check done, clean house and get UID that ran ifchk.
     */
    pwData = NULL;

    if( ( pwData = getpwuid( getuid() ) ) == NULL )
    {
        perror( "getpwuid" );
        return (NULL);
     }

    return (pwData);
}
