/************************************************************************
 * log.h                                                                *
 *                                                                      *
 * Copyright (C) 2002 - 2005 Joshua Birnbaum <engineer@noorg.org>.      *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/*************************************************************
 * Project ifchk -- Host based network interface promiscuous *
 *                  mode detection and handling.             *
 *                                                           *
 * Version:         0.95b3                                   *
 *                                                           *
 * --------------------------------------------------------- *
 *							     *
 * log.h:           Standard header file.                    *
 *************************************************************/

/**********************
 * include directives *
 **********************/

#ifndef LOG_H 
#define LOG_H 

#include <syslog.h>


/*********************
 * define directives *
 *********************/

#define DOWN 2			/* Interface down. */
#define NORMAL 3		/* Interface normal/up. */
#define PROMISC 4		/* Interface promiscuous. */
#define PROMISC_DISABLE 5	/* Interface promiscuous, disabled. */
#define LOGWARNING 6		/* Logging priority. */
#define LOGINFO 7		/* Logging priority. */
#define NULLSTATE 8		/* Dummy interface state - for ifMetric(). */
#define STATSTATE 9		/* Dummy interface state - for nlRcvMsg(). */


/***********************
 * function prototypes *
 ***********************/

int writeLog( int priority, char *object, int ifState );

#endif /* LOG_H */
