/************************************************************************
 * config.h                                                             *
 *                                                                      *
 * Copyright (C) 2002 - 2017 Joshua Birnbaum <engineer@noorg.org>.      *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/*************************************************************
 * Project ifchk -- Host based network interface promiscuous *
 *                  mode detection and handling.             *
 *                                                           *
 * Version:         1.0.7                                    *
 *                                                           *
 * --------------------------------------------------------- *
 *							     *
 * config.h:        Standard header file.                    *
 *************************************************************/

/**********************
 * include directives *
 **********************/

#ifndef CONFIG_H
#define CONFIG_H

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>

#include "error.h"
#include "filestat.h"


/*********************
 * define directives *
 *********************/

#define FALSE 0					/* Value of false. */
#define TRUE 1					/* Value of true. */
#define STRBUFSZ 1024				/* Size of config file line buffer. */
#define R_GRP_OTH ( S_IRGRP | S_IROTH )		/* File is readable by group, other. */
#define W_GRP_OTH ( S_IWGRP | S_IWOTH )		/* File is writeable by group, other. */


/*************************
 * structure definitions *
 *************************/

/*
 * Config file keyword/value pair structure definition.
 */
struct conf
{
    char keyword[STRBUFSZ];			/* Config file keyword. */
    char value[STRBUFSZ];			/* Config file value. */
    int lineNum;				/* Config file line number. */
    struct conf *next;				/* Pointer to next struct conf. */
};


/***********************
 * function prototypes *
 ***********************/

struct conf *loadConfig( char *confFile );
int chkRedef( char *redefPtr, int lineNum, char *confFile );
int chkKeyword( char *keyword, int lineNum, char *confFile );
int chkValue( char *keyword, char *value, int lineNum, char *confFile );

#endif /* CONFIG_H */
