/************************************************************************
 * filestat.h                                                           *
 *                                                                      *
 * Copyright (C) 2002 - 2017 Joshua Birnbaum <engineer@noorg.org>.      *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/*************************************************************
 * Project ifchk -- Host based network interface promiscuous *
 *                  mode detection and handling.             *
 *                                                           *
 * Version:         1.0.8                                    *
 *                                                           *
 * --------------------------------------------------------- *
 *                                                           *
 * filestat.h:      Standard header file.                    *
 *************************************************************/

/**********************
 * include directives *
 **********************/

#ifndef FILESTAT_H
#define FILESTAT_H

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <libgen.h>
#include <unistd.h>
#include <limits.h>
#include <sys/param.h>
#include <errno.h>

#include "error.h"


/*********************
 * define directives *
 *********************/

#define FALSE 0									/* Value of false. */
#define TRUE 1									/* Value of true. */
#define R_GRP_OTH ( S_IRGRP | S_IROTH )						/* Readable by group, other mode mask. */
#define W_GRP_OTH ( S_IWGRP | S_IWOTH )						/* Writable by group, other mode mask. */
#define X_USR_GRP_OTH ( S_IXUSR | S_IXGRP | S_IXOTH )				/* Executable by owner, group, other mode mask. */
#define PROCMASK ( S_IRUSR | S_IRGRP | S_IROTH )				/* Readble by owner, group, other mode mask. */

#ifndef ALLPERMS
#define ALLPERMS ( S_ISUID | S_ISGID | S_ISVTX | S_IRWXU | S_IRWXG | S_IRWXO )	/* Mode 7777 mode mask. */
#endif /* ALLPERMS */


/*************************
 * structure definitions *
 *************************/

/*
 * fsObj structure definition.
 */
struct fsObj
{
    int openRead;		/* Open read-only flag. */
    int procLen;		/* Linux /proc file length check flag. */
    int procOwner;		/* Linux /proc file owner check flag. */
    int procMode;		/* Linux /proc file permissions check flag. */
    int regLen;			/* Regular file length check flag. */
    int regMode;		/* Regular file permissions check.flag. */
};


/***********************
 * function prototypes *
 ***********************/

FILE *statFile( char *path, struct fsObj fsObjAttrs );

#endif /* FILESTAT_H */
