/************************************************************************
 * pidfile.h                                                            *
 *                                                                      *
 * Copyright (C) 2002 - 2018 Joshua Birnbaum <engineer@noorg.org>.      *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/*************************************************************
 * Project ifchk -- Host based network interface promiscuous *
 *                  mode detection and handling.             *
 *                                                           *
 * Version:         1.1.0                                    *
 *                                                           *
 * --------------------------------------------------------- *
 *                                                           *
 * pidfile.h:       Standard header file.                    *
 *************************************************************/

/**********************
 * include directives *
 **********************/

#ifndef PIDFILE_H
#define PIDFILE_H

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "error.h"
#include "log.h"


/**********************
 * define directives. *
 **********************/

#define FALSE 0							/* Value of false. */
#define TRUE 1							/* Value of true. */
#define QUERYLOCK 2						/* lockCtl() command. */
#define LOCK 3							/* lockCtl() command. */
#define UNLOCK 4						/* lockCtl() command. */
#define PIDMASK (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)		/* ifchk PID file permissions mask. */


/***********************
 * function prototypes *
 ***********************/

int lockCtl( int lockCmd );

#endif /* PIDFILE_H */
