/************************************************************************
 * ifchk.h                                                              *
 *                                                                      *
 * Copyright (C) 2002 - 2020 Joshua Birnbaum <engineer@noorg.org>.      *
 * All Rights Reserved.                                                 *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published    *
 * by the Free Software Foundation; either version 2 of the License, or *
 * (at your option) any later version.                                  *
 *                                                                      *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    *
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY      *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; see the file COPYING. If not, write to the  *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, *
 * MA 02111-1307, USA.                                                  *
 ************************************************************************/

/*************************************************************
 * Project ifchk -- Host based network interface promiscuous *
 *                  mode detection and handling.             *
 *                                                           *
 * Version:         1.1.2                                    *
 *                                                           *
 * --------------------------------------------------------- *
 *                                                           *
 * ifchk.h:         Standard header file.                    *
 *************************************************************/

/**********************
 * include directives *
 **********************/

#ifndef IFCHK_H
#define IFCHK_H

#include <stdio.h>
#include <stdlib.h>
#include <sys/utsname.h>
#include <pwd.h>
#include <sys/resource.h>
#include <signal.h>
#include <limits.h>
#include <string.h>

#include "log.h"
#include "daemon.h"
#include "error.h"
#include "pidfile.h"
#include "config.h"
#include "filestat.h"
#include "psig.h"
#include "ptimer.h"
#include "evtloop.h"


/*********************
 * define directives *
 *********************/

#define VERS "1.1.2"                        /* ifchk revision number. */
#define FALSE 0                             /* Value of false. */
#define TRUE 1                              /* Value of true. */
#define ERRMASK (S_IRUSR | S_IWUSR )        /* ifchk.errlog file permissions mask. */
#define SNBUFSZ 8                           /* ifchk shutdown signal log buffer size. */


/***********************
 * function prototypes *
 ***********************/

void ifchkHelp();
int ifchkRev( void );

#endif /* IFCHK_H */
